ToolBoxHelperFixes = {}
ToolBoxHelperFixes.TOOLBOX_XML_PATH = Utils.getFilename("toolBox/toolBox.xml", g_currentModDirectory)
print("TOOLBOX_XML_PATH: " .. tostring(ToolBoxHelperFixes.TOOLBOX_XML_PATH))

function ToolBoxHelperFixes:onVehicleCollisionDistanceCallback(superFunc, distance, objectId, subShapeIndex, isLast, trigger)
    -- check for mission and strategy existence in case we receive the async callback after one of them has been removed (e.g. leaving game)
    if g_currentMission ~= nil and self.collisionTriggerByVehicle ~= nil then
        -- ignore callbacks that arrive after the vehicle has been deleted
        for vehicle, _ in pairs(self.collisionTriggerByVehicle) do
            if vehicle.isDeleted or vehicle.isDeleting then
                return false
            end
        end

        if objectId ~= 0 then

            local player = g_currentMission.playerSystem:getPlayerByRootNode(objectId)
            if player ~= nil then
                trigger.hitCounter = trigger.hitCounter + 1
            else
                local vehicle = g_currentMission.nodeToObject[objectId]
                if vehicle == nil or self.collisionTriggerByVehicle[vehicle] == nil then
                    -- exclude all objects that have 'road' in their name -> for wrongly set up mod map roads
                    if not getHasTrigger(objectId) then--and not getName(objectId):contains("road") then
                        if vehicle == nil or vehicle.getRootVehicle == nil or vehicle:getRootVehicle() ~= self.rootVehicle then
                            if getRigidBodyType(objectId) ~= RigidBodyType.DYNAMIC then
                                trigger.hitStaticCounter = trigger.hitStaticCounter + 1
                            else
                                -- we fully ignore other than vehicle dynamic objects (bales, traffic signs, etc.)
                                if bit32.band(getCollisionFilterGroup(objectId), CollisionFlag.VEHICLE) ~= 0 then
                                    if vehicle ~= nil and vehicle.xmlFile ~= nil and vehicle.xmlFile.filename == ToolBoxHelperFixes.TOOLBOX_XML_PATH then
                                        -- do nothing - ignore toolbox vehicles
                                    else
                                        trigger.hitCounter = trigger.hitCounter + 1
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end

        -- we store the first hit position and then calculate the distance to this position afterwards
        -- this works fine while driving straight to the collision, but is not accorate in curves
        -- but it is much cheaper than checking for the real distance to the collision the engine

        if objectId == 0 or isLast then
            local hasCollision = trigger.hitCounter > 0
            if hasCollision ~= trigger.hasCollision then
                trigger.hasCollision = hasCollision

                if hasCollision then
                    trigger.dynamicHitPointValid = true
                    trigger.dynamicHitPoint[1], trigger.dynamicHitPoint[2], trigger.dynamicHitPoint[3] = getWorldTranslation(trigger.node)
                    trigger.dynamicHitPointInitialDistance = trigger.vehicle.lastSpeedReal * g_physicsDt * AICollisionTriggerHandler.UPDATE_INTERVAL
                else
                    trigger.dynamicHitPointValid = false
                    trigger.dynamicHitPointDistance = math.huge
                end

                self:updateBlockedCallback()
            end

            local hasStaticCollision = trigger.hitStaticCounter > 0
            if hasStaticCollision ~= trigger.hasStaticCollision then
                trigger.hasStaticCollision = hasStaticCollision

                if hasStaticCollision then
                    trigger.staticHitPointValid = true
                    trigger.staticHitPoint[1], trigger.staticHitPoint[2], trigger.staticHitPoint[3] = getWorldTranslation(trigger.node)
                    trigger.staticHitPointInitialDistance = trigger.vehicle.lastSpeedReal * g_physicsDt * AICollisionTriggerHandler.UPDATE_INTERVAL
                else
                    trigger.staticHitPointValid = false
                    trigger.staticHitPointDistance = math.huge
                end

                self:updateStaticCollisionCallback()
            end

            return false
        else
            return true
        end
    end

    return
end

AICollisionTriggerHandler.onVehicleCollisionDistanceCallback = Utils.overwrittenFunction(AICollisionTriggerHandler.onVehicleCollisionDistanceCallback, ToolBoxHelperFixes.onVehicleCollisionDistanceCallback)