WheelieScript = {};

source(g_currentModDirectory.."WheelieEvent.lua");

function WhelieButtonAction()
end

function WheelieScript:updateActionEvents()

	if WheelieScript.EventId == nil then
		valid, eventId = g_inputBinding:registerActionEvent(InputAction.Whelie, "Whelie", WhelieButtonAction, false, true, true, true);
		if valid then WheelieScript.EventId = eventId; end
	end


	if WheelieScript.EventId ~= nil then
		if WheelieScript:GetVehicle() ~= nil and WheelieScript.Backwards == false and WheelieScript:GetVehicle():getLastSpeed() < 1 then
			g_inputBinding:setActionEventActive(WheelieScript.EventId, true);
		else
			g_inputBinding:setActionEventActive(WheelieScript.EventId, false);
		end;
	end;
end

function WheelieScript:RotateVehicle(Vehicle,x,y,z)
	local Rx,Ry,Rz = localDirectionToWorld(Vehicle.rootNode,x,y,z);
	setAngularVelocity(Vehicle.rootNode,Rx,Ry,Rz);
end;

local InWheelie = false;
local InputMode = false;

function WheelieScript:WheelieUpdate()	
	local CurrentSpeed = WheelieScript:GetVehicle():getLastSpeed();
	if CurrentSpeed > 1 and InWheelie == true and WheelieScript.Backwards == false then 
		local Vector = CurrentSpeed/13;
		if Vector > 0.7 then Vector = 0.7 end;
		g_client:getServerConnection():sendEvent(WheelieEvent.new(WheelieScript:GetVehicle(),-Vector));
	end;
end;

function WheelieScript:GetVehicle()
	local player = g_currentMission.playerSystem.players[g_currentMission.playerUserId]
	if player == nil then
		return nil
	end

	return player:getCurrentVehicle();
end

function WheelieScript:update()	

	if WheelieScript:GetVehicle() == nil then return; end

	WheelieScript.Backwards = WheelieScript:GetVehicle().movingDirection == -1;
	
	if InWheelie == false and Input.isKeyPressed(Input.KEY_lshift) and WheelieScript:GetVehicle():getLastSpeed() < 1 then	
		InputMode = false;
		InWheelie = true;
	end;

	if InWheelie == false and getInputButton(Input.BUTTON_11,0) == 1 and WheelieScript:GetVehicle():getLastSpeed() < 1 then
		InputMode = true;
		InWheelie = true;
	end;

	if InWheelie == true and InputMode == false and Input.isKeyPressed(Input.KEY_lshift) == false then InWheelie = false; end; 
	if InWheelie == true and InputMode == true and getInputButton(Input.BUTTON_11,0) ~= 1 then InWheelie = false; end; 

	WheelieScript:WheelieUpdate();
	WheelieScript:updateActionEvents();
end;

addModEventListener(WheelieScript);