WheelieEvent = {}

local WheelieEvent_mt = Class(WheelieEvent, Event)
InitEventClass(WheelieEvent, "WheelieEvent")

function WheelieEvent.emptyNew()
    local self = Event.new(WheelieEvent_mt)
    return self
end

function WheelieEvent.new(vehicle, amount)
    local self = WheelieEvent.emptyNew()
    self.vehicle = vehicle
    self.amount = amount
    return self
end

function WheelieEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.amount = streamReadFloat32(streamId)
    self:run(connection)
end

function WheelieEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteFloat32(streamId, self.amount)
end

function WheelieEvent:run(connection)
    if not connection:getIsServer() then
        WheelieScript:RotateVehicle(self.vehicle,self.amount,0,0);
    end
end