-- Measure Script for FarmingSimulator 2025
-- @author      Danielmodding
-- @version     v1.0.0.0 Release Giants FarmingSimulator Modhub
-- @date        12/11/2024
-- @info		Measure Script for FarmingSimulator 2025


measure = {}
MeasureActive = false
MeasureUnitMetric = true
x1 = 0
y1 = 0
z1 = 0
x2 = 0
y2 = 0
z2 = 0

addModEventListener(measure);

function measure:update(dt)
    if MeasureActive then

		local controlledPlayer

		if g_currentMission.controlledPlayer then
			controlledPlayer = g_currentMission.controlledPlayer
		elseif g_currentMission.userManager.getControlledUser then
			controlledPlayer = g_currentMission.userManager:getControlledUser()
		else
			for _, player in pairs(g_currentMission.connectionsToPlayer) do
				if player.isControlled then 
					controlledPlayer = player
					break
				end
			end
		end

		if controlledPlayer and type(controlledPlayer.getPosition) == "function" then
			local x2, y2, z2 = controlledPlayer:getPosition()

	
			local c2 = math.pow((x1 - x2), 2) + math.pow((z1 - z2), 2)
			local cY = math.pow((y1 - y2), 2)

			distance = math.sqrt(c2 + cY)

			if MeasureUnitMetric == false then
				distance = distance * 3.28
			end

			distance = math.floor(distance * 100 + 0.5) / 100
		end
    end
end

function measure.prerequisitesPresent(specializations)
	return true;
end

function measure:loadMap(name)
end;

function measure:mouseEvent(posX, posY, isDown, isUp, button)

	if isDown and button == 3 and Input.isKeyPressed(Input.KEY_lalt) then
		if(MeasureActive == false) then

			if g_currentMission.controlledPlayer then
				controlledPlayer = g_currentMission.controlledPlayer
			elseif g_currentMission.userManager.getControlledUser then
				controlledPlayer = g_currentMission.userManager:getControlledUser()
			else
				for _, player in pairs(g_currentMission.connectionsToPlayer) do
					if player.isControlled then 
						controlledPlayer = player
						break
					end
				end
			end

			if controlledPlayer and type(controlledPlayer.getPosition) == "function" then
				x1, y1, z1 = controlledPlayer:getPosition()
			end


			MeasureActive = true;
		else
			MeasureActive = false;
		end;
	end;

	if isDown and button == 2 then
		if MeasureActive then
			MeasureUnitMetric = not MeasureUnitMetric
		end
	end
end

function measure:draw()

	if MeasureActive == true then
		if MeasureUnitMetric == true then
			g_currentMission:addExtraPrintText(distance .. " m");
		else
			g_currentMission:addExtraPrintText(distance .. " ft");
		end
	end;
end

function measure:keyEvent(unicode, sym, modifier, isDown)
end

function measure:deleteMap()
end