-- KommunalMachine
-- Specialization that allows the vehicles to which it is applied to carry out progress in municipal service missions
-- Authors: SMI Modding Team (Nicola)
-- Game version: Farming Simulator 25
-- Version: 1.0 - 27.02.2025
local modName = g_currentModName

KommunalMachine = {}
KommunalMachine.SPEC_TABLE_NAME = "spec_"..modName..".kommunalMachine"
KommunalMachine.className = "KommunalMachine"


function KommunalMachine.prerequisitesPresent(specializations)
    return true
end

function KommunalMachine.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", KommunalMachine)
end

function KommunalMachine.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "processMissionWorkArea", KommunalMachine.processMissionWorkArea)
end


function KommunalMachine.initSpecialization()
    local schema = Vehicle.xmlSchema
    schema:setXMLSpecializationType("kommunalMachine")
	
    schema:setXMLSpecializationType()
end

function KommunalMachine:onUpdate(dt) 
	local spec = self[KommunalMachine.SPEC_TABLE_NAME]

    -- lista delle work areas di tipo mulcher
    local mulcher_workAreas = spec:getTypedWorkAreas(WorkAreaType.MULCHER)
    local mower_workAreas = spec:getTypedWorkAreas(WorkAreaType.MOWER)

    for workArea_idx = 1, #mulcher_workAreas do
        local work_area = mulcher_workAreas[workArea_idx]
        self:processMissionWorkArea(work_area, dt)
    end

    for workArea_idx = 1, #mower_workAreas do
        local work_area = mower_workAreas[workArea_idx]
        self:processMissionWorkArea(work_area, dt)
    end
end

function KommunalMachine:processMissionWorkArea(workArea, dt) 
    if workArea == nil then
        return end

    if self:getIsWorkAreaProcessing(workArea) then
        local xs,ys,zs = getWorldTranslation(workArea.start)
        local xw,yw,zw = getWorldTranslation(workArea.width)
        local xh,yh,zh = getWorldTranslation(workArea.height)
        local wac_x, wac_y, wac_z = (xs+xw+xh)/3, (ys+yw+yh)/3, (zs+zw+zh)/3     -- x, y e z del centro della work area 

        local player_farm_id = g_currentMission:getFarmId() 
        local isOwned = g_farmlandManager:getIsOwnedByFarmAtWorldPosition(player_farm_id, wac_x, wac_z)

        local isOnField, densityBits, groundType = FSDensityMapUtil.getFieldDataAtWorldPosition(wac_x, wac_y, wac_z)
        -- la terra permette il progresso della missione solo se non è già posseduta oppure è posseduta ma non si è su un campo
        local land_valid = (not isOwned or (not isOnField))
        -- se il terreno è erba (su un campo) o terra normale (erba fuori dai campi, in quanto il resto non attiva la work area)
        local terrain_valid = (groundType == 0 or groundType == FieldGroundType.GRASS or groundType == FieldGroundType.NONE)

        if terrain_valid and land_valid then
            -- loop per ogni mission per vedere se ci sono missioni kommunal attive 
            for i = 1, #g_missionManager.missions do
                local mission = g_missionManager.missions[i]

                if mission.type.name == 'kommunalMission' and mission.status == MissionStatus.RUNNING then
                    -- se anche ci sono più work area di tipo mulcher prendo per buona la prima
                    local work_area_width = workArea.workWidth
                    local speed_kmh = self:getLastSpeed()
                    -- dt è in millisecondi, speed_kmh in km/h, lo converto in m/s e il risultato è in metri quadri
                    local trimmed_surface = speed_kmh/3.6 * dt/1000 * work_area_width
                    mission:registerTrimmedArea(trimmed_surface)
                    break
                end
            end
        end
    end
end