-- AddSpecialization
-- Script that allows to dynamically add a specialization for a script to some specified custom types (to request the compatibility for your mods please contact smimoddingteam@gmail.com)
-- Authors: SMI Modding Team (Nicola)
-- Game version: Farming Simulator 25
-- Version: 1.0 - 23.02.2025
AddSpec = {}

local modDirectory = g_currentModDirectory -- Percorso della cartella dove si trova il modDesc dello script/addon (Accertato)

function addSpecialization()
    local modDesc_id = loadXMLFile("ModDescFile", modDirectory .. "modDesc.xml")
    local specialization_xml_key = "modDesc.specializations.specialization"
    
    if not hasXMLProperty(modDesc_id, specialization_xml_key) then
        Logging.warning("Specialization XML key not found in modDesc.xml when trying to apply the Kommunal machine specialization")
        return
    end

    local spec_name = getXMLString(modDesc_id, specialization_xml_key .. "#name")

    local dest_mod_idx = 0 
    while true do
        -- "modDesc.specializations.specialization.destinationMod({index})"
        local dest_mod_xml_key = string.format("%s.destinationMod(%s)", specialization_xml_key, dest_mod_idx)
        if not hasXMLProperty(modDesc_id, dest_mod_xml_key) then
            break 
        end        

        local add_to = getXMLString(modDesc_id, dest_mod_xml_key .. "#addTo")
        local dest_mod_name = getXMLString(modDesc_id, dest_mod_xml_key .. "#name")
        local type_name = dest_mod_name .. "." .. add_to
        if g_vehicleTypeManager:getTypes()[type_name] ~= nil then
            g_vehicleTypeManager:addSpecialization(type_name, spec_name) 
        end
        
        dest_mod_idx = dest_mod_idx + 1            
    end    
        
    delete(modDesc_id)
end

TypeManager.validateTypes =
    Utils.appendedFunction(
    TypeManager.validateTypes,
    function(self)
        if self.typeName == "vehicle" then
            addSpecialization()
        end
    end
)