EAS_NumberPickerDialog = {
	CONTROLS = {
		DIALOG_TITLE = "dialogTitleElement",
		NO_BUTTON = "noButton",
		YES_BUTTON = "yesButton"
	}
}
local EAS_NumberPickerDialog_mt = Class(EAS_NumberPickerDialog, YesNoDialog)

function EAS_NumberPickerDialog.new(target, custom_mt)
	local self = DialogElement.new(target, custom_mt or EAS_NumberPickerDialog_mt)
	self.isBackAllowed = false
	self.inputDelay = 250
	self.numAnimals = 1
    self.maxNumAnimals = 1
	self.optionElements = {}

	return self
end

function EAS_NumberPickerDialog:onOpen()
	EAS_NumberPickerDialog:superClass().onOpen(self)

	self.inputDelay = self.time + 250

	for element, amount in pairs(self.optionElements) do
		element.elements[3]:setText(string.format(g_i18n:getText("eas_current_value_max_value"), self.numAnimals, self.maxNumAnimals))
	end

	self:updateAmount(0)
end

function EAS_NumberPickerDialog:setMaxNumAnimals(maxNumAnimals)
    self.numAnimals = maxNumAnimals
    self.maxNumAnimals = maxNumAnimals
	self:updateAmount(0)
end

function EAS_NumberPickerDialog:setCallback(callbackFunc, target)
	self.callbackFunc = callbackFunc
	self.target = target
end


function EAS_NumberPickerDialog.onYes(self, _)
	return self:sendCallback(true)
end
function EAS_NumberPickerDialog.onNo(self, _)
	return self:sendCallback(false)
end

function EAS_NumberPickerDialog:sendCallback(success)
	if self.inputDelay < self.time then
		self:close()

		if self.callbackFunc ~= nil then
			if self.target ~= nil then
				self.callbackFunc(self.target, self.numAnimals, success)
			else
				self.callbackFunc(self.numAnimals, success)
			end
		end
	end
end

function EAS_NumberPickerDialog:onClickLeft(element)
	local amount = -1 * self.optionElements[element.parent]

	self:updateAmount(amount)
end

function EAS_NumberPickerDialog:onClickRight(element)
	local amount = self.optionElements[element.parent]

	self:updateAmount(amount)
end

function EAS_NumberPickerDialog:updateAmount(diff)
    if self.numAnimals + diff > self.maxNumAnimals then
        self.numAnimals = 1
    elseif self.numAnimals + diff < 1 then
        self.numAnimals = self.maxNumAnimals
    else
        self.numAnimals = math.min(math.max(self.numAnimals + diff, 1), self.maxNumAnimals)
    end

	for element, amount in pairs(self.optionElements) do
		element.elements[3]:setText(string.format(g_i18n:getText("eas_current_value_max_value"), self.numAnimals, self.maxNumAnimals))
    end
end

function EAS_NumberPickerDialog:onCreateScroller(element)
	self.optionElements[element] = self.maxNumAnimals
end