CutBaleEvent = {}

local CutBaleEvent_mt = Class(CutBaleEvent, Event)
InitEventClass(CutBaleEvent, "CutBaleEvent")

function CutBaleEvent.emptyNew()
    local self = Event.new(CutBaleEvent_mt)
    return self
end

function CutBaleEvent.new(amount, fillTypeIndex, x, y, z)
    local self = CutBaleEvent.emptyNew()

    self.amount = amount
    self.fillTypeIndex = fillTypeIndex

    self.x = x
    self.y = y
    self.z = z

    return self
end

function CutBaleEvent:readStream(streamId, connection)
    self.amount = streamReadFloat32(streamId)
    self.fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)

    self.x = streamReadFloat32(streamId)
    self.y = streamReadFloat32(streamId)
    self.z = streamReadFloat32(streamId)

    self:run(connection)
end

function CutBaleEvent:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.amount)
    streamWriteUIntN(streamId, self.fillTypeIndex, FillTypeManager.SEND_NUM_BITS)

    streamWriteFloat32(streamId, self.x)
    streamWriteFloat32(streamId, self.y)
    streamWriteFloat32(streamId, self.z)
end

function CutBaleEvent:run(connection)
    if not connection:getIsServer() then
        local player = g_currentMission:getPlayerByConnection(connection);
        CutBale:TipToGround(self.amount, self.fillTypeIndex, self.x, self.y, self.z, player);
    end
end
