---This class adds UI controls for settings of the mod
---@class AutoFOVUI
---@field settings AutoFOVSettings @The settings object
---@field controls table @A list of all UI controls
AutoFOVUI = {
}

local AutoFOVUI_mt = Class(AutoFOVUI)

---Creates a new instance
---@param settings AutoFOVSettings @The settings object
---@return AutoFOVUI @The new instance
function AutoFOVUI.new(settings)
	local self = setmetatable({}, AutoFOVUI_mt)

	self.controls = {}
	self.settings = settings
	self.isInitialized = false
	return self
end

---Injects the UI into the base game UI
function AutoFOVUI:injectUiSettings()
	if self.isInitialized then
		return
	end
	self.isInitialized = true

	-- Get a reference to the base game general settings page
	local settingsPage = g_gui.screenControllers[InGameMenu].pageSettings

	-- Define the UI controls. For each control, a <prefix>_<name>_short and _long key must exist in the i18n values
	local controlProperties = {
		{ name = "targetFOV", min = 10, max = 100, step = 5, autoBind = true, nillable = false },
        { name = "targetFOVInterior", min = 10, max = 100, step = 5, autoBind = true, nillable = false },
        { name = "harvesterFOVInterior", min = 10, max = 100, step = 5, autoBind = true, nillable = false }
	}
	UIHelper.createControlsDynamically(settingsPage, "af_section_title", self, controlProperties, "af_")
	UIHelper.setupAutoBindControls(self, self.settings, AutoFOVUI.onSettingsChange)

	-- Apply initial values
	self:updateUiElements()

	-- Trigger an update in order to enable/disable controls on settings frame open
	InGameMenuSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuSettingsFrame.onFrameOpen, function()
		self:updateUiElements(true) -- skip autobind controls
	end)
end

function AutoFOVUI:onSettingsChange()
	self:updateUiElements()
    -- Local settings, so we just save immediately instead of publishing
    AutoFOVSettingsRepository.storeSettings(self.settings)
end

function AutoFOVUI:updateUiElements(skipAutoBindControls)
	if not skipAutoBindControls then
		-- Note: This method is created dynamically by UIHelper.setupAutoBindControls
		self.populateAutoBindControls()
	end

    -- No admin check needed for local settings
	for _, control in ipairs(self.controls) do
		control:setDisabled(false)
	end

	-- Update the focus manager
	local settingsPage = g_gui.screenControllers[InGameMenu].pageSettings
	settingsPage.generalSettingsLayout:invalidateLayout()
end
